<?php
   namespace Elementor;
   
   if (!defined('ABSPATH')) {
       exit;
   } // If this file is called directly, abort.
   
   class Widget_creote_foo_navigation_v1 extends Widget_Base
   {
   
       public function get_name()
       {
           return 'creote-foo-navigation-v1';
       }
   
       public function get_title()
       {
           return __('Navigation v1' , 'creote-addons');
       }
   
       public function get_icon()
       {
           return 'icon-creote-svg';
       }
   
       public function get_categories()
       {
           return ['104'];
       }
   
       
   
       protected function register_controls() {
   
   		$this->start_controls_section(
   			'foo_navigation_content',
   			[
   				'label' => esc_html__( 'Navigation Content', 'creote-addons' ),
   			]
           );
           $this->add_control(
               'navigation_menu_styles',
               [
                   'label' => __('Navigation style', 'creote-addons'),
                   'type' => Controls_Manager::SELECT,
                   'options' => [
                       'style_one' => __( 'Style One', 'creote-addons' ), 
                       'style_two' => __( 'Style Two', 'creote-addons' ),
                       'style_three' => __( 'Style Three', 'creote-addons' ), 
   			   	],
                   'default' => __('style_one' , 'creote-addons'),
               ]
           );
           $this->add_responsive_control(
               'dark_white',
               [
                 'label' => __( 'Service Color Type', 'creote-addons' ),
                 'type' => Controls_Manager::SELECT,
                 'options' => [
                   'dark_color' => __('Dark Color', 'creote-addons'), 
                   'light_color' => __('Light Color', 'creote-addons'),
                   ],
                  'default' => 'light_color',
               ]
             );
           $this->add_control(
   			'hr_one',
   			[
   				'type' => \Elementor\Controls_Manager::DIVIDER,
   			]
   		);
           $this->add_control(
               'navigations',
               [
                   'label' => __('Select Navigation', 'creote-addons'),
                   'type' => Controls_Manager::SELECT2,
                   'options' => creote_navmenu(),
               ]
           );
   
           $this->add_control(
               'navigations_two',
               [
                   'label' => __('Select Navigation', 'creote-addons'),
                   'type' => Controls_Manager::SELECT2,
                   'options' => creote_navmenu(),
                   'condition' => [
                       'navigation_menu_styles' => 'style_three',
                     ],
               ]
           );
   
         $this->add_control(
           'transitions_enable',
          [
             'label' => __('Transitions Enable', 'creote-addons'),
              'type' => Controls_Manager::SWITCHER,
              'label_on' => __('Yes', 'creote-addons'),
              'label_off' => __('No', 'creote-addons'),
              'return_value' => 'yes',
              'default' => 'no',
           ]
         );
   
         $this->add_responsive_control(
           'transitions',
           [
             'label' => __( 'Transitions', 'creote-addons' ),
             'type' => Controls_Manager::SELECT,
             'options' => [
               '0' => __('0ms', 'creote-addons'), 
               '100' => __('100ms', 'creote-addons'),
               '200' => __('200ms', 'creote-addons'),
               '300' => __('300ms', 'creote-addons'),
               '400' => __('400ms', 'creote-addons'),
               '500' => __('500ms', 'creote-addons'),
               '600' => __('600ms', 'creote-addons'),
               '700' => __('700ms', 'creote-addons'),
               '800' => __('800ms', 'creote-addons'),
               '900' => __('900ms', 'creote-addons'),
               '1000' => __('1000ms', 'creote-addons'),
               ],
              'default' => '0',
              'condition' => [
               'transitions_enable' => 'yes',
             ],
           ]
         );
         $this->end_controls_section();
   
         $this->start_controls_section('css_changing',
         [ 
             'label' => __('Style', 'creote-addons'),
             'tab' =>Controls_Manager::TAB_STYLE,
         ]);
   
        
   
       $this->add_control(
           'color_two',
           [
               'label' => __( 'Color', 'creote-addons' ),
               'type' => \Elementor\Controls_Manager::COLOR,
               'selectors' => [
                   '{{WRAPPER}} .footer_widgets.navigation_foo .navigation_foo_inner ul li a ' => 'color: {{VALUE}}',
               ],
           ]
       );
   
   	
       $this->end_controls_section();
    
   	}
       protected function render() {
   		$settings = $this->get_settings_for_display();
           $allowed_tags = wp_kses_allowed_html('post');
           
   		?>
<div class="footer_widgets clearfix navigation_foo <?php echo esc_attr($settings['dark_white']); ?> <?php echo esc_attr($settings['navigation_menu_styles']); ?>" <?php if($settings['transitions_enable'] == 'yes'):  ?>  data-aos="fade-up" data-aos-delay="<?php echo esc_html($settings['transitions']); ?>"  data-aos-offset="0" <?php endif;?>>
   <?php if($settings['navigation_menu_styles'] == 'style_one'): ?>
   <div class="navigation_foo_box">
      <div class="navigation_foo_inner">
         <?php  if(!empty($settings['navigations'])):
            wp_nav_menu(array(
            'menu' => $settings['navigations'],
            )
            ); endif;
            ?>
      </div>
   </div>
   <?php elseif($settings['navigation_menu_styles'] == 'style_two'): ?>
   <div class="navigation_foo_box">
      <div class="navigation_foo_inner">
         <?php  if(!empty($settings['navigations'])):
            wp_nav_menu(array(
            'menu' => $settings['navigations'],
            )
            ); endif;
            ?>
      </div>
   </div>
   <?php elseif($settings['navigation_menu_styles'] == 'style_three'): ?>
   <div class="navigation_foo_box">
      <div class="navigation_foo_inner">
         <div class="left">
            <?php  if(!empty($settings['navigations'])):
               wp_nav_menu(array(
               'menu' => $settings['navigations'],
               )
               ); endif;
               ?>
         </div>
         <div class="right">
            <?php  if(!empty($settings['navigations_two'])):
               wp_nav_menu(array(
               'menu' => $settings['navigations_two'],
               )
               ); endif;
               ?>
         </div>
      </div>
   </div>
   <?php endif; ?>
</div>
<?php 
}
}
Plugin::instance()->widgets_manager->register_widget_type(new Widget_creote_foo_navigation_v1());