<?php
   namespace Elementor;
   
   if (!defined('ABSPATH')) {
       exit;
   } // If this file is called directly, abort.
   
   class Widget_creote_contact_form_footer_v1 extends Widget_Base
   {
   
       public function get_name()
       {
           return 'creote-contact-form-footer-v1';
       }
   
       public function get_title()
       {
           return __('Footer Form   V1' , 'creote-addons');
       }
   
       public function get_icon()
       {
           return 'icon-creote-svg';
       }
   
       public function get_categories()
       {
           return ['104'];
       }
   
       
   
       protected function register_controls() {
   		$this->start_controls_section(
   			'contact_form',
   			[
   				'label' => esc_html__( 'Contact Form', 'creote-addons' ),
   			]
           );
   
           $this->add_control(
   			'contact_style',
   			[
   				'label'   => esc_html__( 'Choose Style', 'creote-addons' ),
   				'type'    => Controls_Manager::SELECT,
   				'default' => 'type_one',
   				'options' => array(
   					'type_one' => esc_html__( 'Style One', 'creote-addons' ),
   				),
   			]
           );
           $this->add_control(
   			'dark_light',
   			[
   				'label'   => esc_html__( 'Dark / Light', 'creote-addons' ),
   				'type'    => Controls_Manager::SELECT,
   				'default' => 'light_c',
   				'options' => array(
   					'light_c' => esc_html__( 'Light Color', 'creote-addons' ),
             'dark_c' => esc_html__( 'Dark Color', 'creote-addons' ),
   				),
   			]
           );
           $this->add_control(
   			'title',
   			[
   				'label'       => __( 'Title', 'creote-addons' ),
   				'type'        => Controls_Manager::TEXTAREA,
                   'default' => __( 'Contact Us', 'creote-addons' ),
   				'placeholder' => __( 'Contact Us', 'creote-addons' ),
   			]
          );
    
         $this->add_control(
   			'contact_form_url',
   			[
   				'label'       => __( 'Contact Form 7 Url', 'creote-addons' ),
   				'type'        => Controls_Manager::TEXTAREA,
   				'dynamic'     => [
   					'active' => true,
   				],
   				'placeholder' => __( 'Enter your Contact Form 7 Url', 'creote-addons' )
   			]
         );
   
       
    
        $this->add_control(
         'transitions_enable',
        [
           'label' => __('Transitions Enable', 'creote-addons'),
            'type' => Controls_Manager::SWITCHER,
            'label_on' => __('Yes', 'creote-addons'),
            'label_off' => __('No', 'creote-addons'),
            'return_value' => 'yes',
            'default' => 'yes',
         ]
       );
   
       $this->add_responsive_control(
         'transitions',
         [
           'label' => __( 'Transitions', 'creote-addons' ),
           'type' => Controls_Manager::SELECT,
           'options' => [
             '0' => __('0ms', 'creote-addons'), 
             '100' => __('100ms', 'creote-addons'),
             '200' => __('200ms', 'creote-addons'),
             '300' => __('300ms', 'creote-addons'),
             '400' => __('400ms', 'creote-addons'),
             '500' => __('500ms', 'creote-addons'),
             '600' => __('600ms', 'creote-addons'),
             '700' => __('700ms', 'creote-addons'),
             '800' => __('800ms', 'creote-addons'),
             '900' => __('900ms', 'creote-addons'),
             '1000' => __('1000ms', 'creote-addons'),
             ],
            'default' => '0',
            'condition' => [
             'transitions_enable' => 'yes',
           ],
         ]
       );
    
      
         
           $this->end_controls_section();
   
    
           
          
   	}
       protected function render() {
   		$settings = $this->get_settings_for_display();
           $allowed_tags = wp_kses_allowed_html('post');
     
   		?>
<section class="footer_contact_form <?php echo esc_attr($settings['dark_light']); ?> <?php echo esc_attr($settings['contact_style']); ?>" <?php if($settings['transitions_enable'] == 'yes'):  ?>  data-aos="fade-up" data-aos-delay="<?php echo esc_html($settings['transitions']); ?>"  data-aos-offset="0" <?php endif;?>>
   <div class="form_box_foo">
      <?php if(!empty($settings['title'])): ?>
      <h2> <?php echo wp_kses( $settings['title'] , $allowed_tags);?></h2>
      <?php endif; ?>
      <div class="contact_form_shortcode">
         <?php echo do_shortcode( $settings['contact_form_url'] );?>
      </div>
   </div>
</section>
<?php 
}
}
Plugin::instance()->widgets_manager->register_widget_type(new Widget_creote_contact_form_footer_v1());